IF EXISTS (SELECT 1 FROM SYS.TRIGGERS WHERE NAME = 'TRG_PDV_VD_NFCE_INTEGRA_BENNER_EVENTOS')
BEGIN
	DROP TRIGGER TRG_PDV_VD_NFCE_INTEGRA_BENNER_EVENTOS
END 
GO 

/*
=======================================================================================
'TRIGGER.............: TRG_PDV_VD_NFCE_INTEGRA_BENNER_EVENTOS
'Função..............:
'Objetivo............:
'Tabelas.............: PDV_VD_NFCE
'Dt Modificação......: 02/11/2023
'Modificação.........: Otimização do sql
'=======================================================================================

0 = PENDENTE,
1 = EM_PROCESSAMENTO,
2 = SUCESSO,
3 = FALHA,
4 = REPROCESSADO
*/

CREATE TRIGGER TRG_PDV_VD_NFCE_INTEGRA_BENNER_EVENTOS ON PDV_VD_NFCE
FOR INSERT, UPDATE
AS

	DECLARE @DS_HOSTNAME VARCHAR(100) = HOST_NAME();

	UPDATE A
	  SET A.ST_EVENTO = 4
	  FROM INSERTED I
	       JOIN INTEGRA_BENNER_EVENTOS A ON I.CD_NFCE = A.CD_REGISTRO
     WHERE A.ST_EVENTO = 3

 	INSERT INTO INTEGRA_BENNER_EVENTOS (TABELA, CD_EMP , CD_FILIAL, CD_REGISTRO, TP_EVENTO, HR_EVENTO, ST_EVENTO , DT_ULT_ALT, CD_USU, DT_DOCUMENTO, APP_NAME, HOST_NAME, TOPICO )
	SELECT
		'PDV_VD_NFCE'												AS TABELA
		,1															AS CD_EMP
		,PDV_VD_NFCE.CD_FILIAL										AS CD_FILIAL
		,PDV_VD_NFCE.CD_NFCE											AS CD_REGISTRO
		,1															AS TP_EVENTO
		,GETDATE()													AS HR_EVENTO
		,0															AS ST_EVENTO
		,PDV_VD_NFCE.DT_ENVIO		    							AS DT_ULT_ALT
		,PDV_VD.CD_USU	 											AS CD_USU
		,GETDATE()													AS DT_DOCUMENTO
		,'TRG_PDV_VD_NFCE_INTEGRA_BENNER_EVENTOS - ' + APP_NAME()	AS [APP_NAME]
		,@DS_HOSTNAME												AS HOST_NAME
		,5															AS TOPICO
      FROM INSERTED PDV_VD_NFCE 
	  INNER JOIN PDV_VD_PDV_VD_NFCE ON
			PDV_VD_PDV_VD_NFCE.CD_EMP = PDV_VD_NFCE.CD_EMP
			AND PDV_VD_PDV_VD_NFCE.CD_FILIAL = PDV_VD_NFCE.CD_FILIAL
			AND PDV_VD_PDV_VD_NFCE.CD_NFCE = PDV_VD_NFCE.CD_NFCE
		INNER JOIN PDV_VD ON
			PDV_VD.CD_EMP = PDV_VD_PDV_VD_NFCE.CD_EMP
			AND PDV_VD.CD_FILIAL = PDV_VD_PDV_VD_NFCE.CD_FILIAL
			AND PDV_VD.CD_VD = PDV_VD_PDV_VD_NFCE.CD_VD
		WHERE NOT EXISTS (
					SELECT 
						1 
					FROM 
						INTEGRA_BENNER_EVENTOS (NOLOCK) AA 
					WHERE 
						AA.CD_EMP = PDV_VD_NFCE.CD_EMP
						AND AA.CD_FILIAL = PDV_VD_NFCE.CD_FILIAL
						AND AA.CD_REGISTRO = PDV_VD_NFCE.CD_NFCE
						AND AA.TABELA = 'PDV_VD_NFCE');
